#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

vector<vector<int>> Dinamicko(int n, const vector<int>& arr) {
    vector<vector<int>> dp(n, vector<int>(n, 0));

    for (int i = 0; i < n; i++) {
        dp[i][i] = arr[i];
    }

    for (int i = 0; i < n; i++) {
        for (int j = i+1; j < n; j++) {
            dp[i][j] = dp[i][j - 1] + arr[j];
        }
    }

    return dp;
}

unordered_map<int, vector<int>> pravljenje_recnika(vector<int>& arr) { //const?
    unordered_map<int, vector<int>> recnik;
    unordered_map<int, int> br;

    int n = arr.size();

    for (int val : arr) {
        recnik[val] = vector<int>(n, 0);
    }

    for (int i = 0; i < n; ++i) {
        int val = arr[i];
        br[val]++;

        for (pair<const int, vector<int>>& pair : recnik) {
            vector<int>& vec = pair.second;
            vec[i] = (i > 0 ? vec[i - 1] : 0);
        }

        recnik[val][i] = br[val];
    }

    return recnik;
}

int main() {
    //unos arr
    int n;
    cin >> n;
    
    vector<int> arr(n);
    for (int i = 0; i < n; ++i) {
        cin >> arr[i];
    }
    
    vector<vector<int>> podnizovi = Dinamicko(n, arr);
    unordered_map<int, vector<int>> recnik = pravljenje_recnika(arr);
    
    int resenje = 0;
    for(int i = 0; i<n;i++){
        for(int j=i;j<n;j++){
            if(podnizovi[i][j] == 0){  //edge case ako je i==j ???
                int mx = 0;
                for (const pair<int, vector<int>>& niz : recnik) {
                    const vector<int>& a = niz.second;
                    int pom = a[j] - a[i];
                    mx = max(mx, pom);
                }

                resenje = max(resenje, mx);
            }
        }
    }
    
    cout<<resenje;
   
    return 0;
}